;==========================================================================
;Version history:
;==========================================================================
;2011/05/24     First edition
;==========================================================================
        .INCLUDE        Inc\ComAir.inc
;==========================================================================
        .CODE
;==========================================================================
;Purpose: Turn on the push-pull DAC for ComAir
;Input: None
;Return: None
;Destroy: A
;==========================================================================
F_CA_TurnOnDAC:
        LDA     P_DAC_Ctrl              ;Enable push-pull DAC
        AND     #(D_DAC_Enable+D_OPN_En+D_OPP_En)
        CMP     #(D_DAC_Enable+D_OPN_En+D_OPP_En)
        BEQ     L_CA_TurnOn_Exit
        %TurnOnDAC
L_CA_TurnOn_Exit:
        RTS
;==========================================================================
;Purpose: Turn off the push-pull DAC for ComAir
;Input: None
;Return: None
;Destroy: A
;==========================================================================
F_CA_TurnOffDAC:
        .IF SPEECH = ON
        LDA     R_SpeechStatus
        BNE     L_CA_TurnOff_Exit
        .ENDIF

        .IF MIDI = ON
        LDA     R_MIDIStatus            ;Check if MIDI is playing
        AND     #D_MIDIEn
        BNE     L_CA_TurnOff_Exit

        LDA     R_SingleNote            ;Check if any single note is played
        ORA     R_SingleDrum            ;Check if any single drum is played
        BNE     L_CA_TurnOff_Exit
        .ENDIF

        .IF SW_ChA = ON
        %IsActiveChA                    ;Check if SW_ChA is active
        BCS     L_CA_TurnOff_Exit
        .ENDIF

        .IF SW_ChB = ON
        %IsActiveChB                    ;Check if SW_ChB is active
        BCS     L_CA_TurnOff_Exit
        .ENDIF

        %TurnOffDAC                     ;Turn off DAC

L_CA_TurnOff_Exit:
        RTS
;==========================================================================
